using UnityEditor;
using UnityEngine;
using UnityEngine.SceneManagement;
using UnityEngine.Rendering;
using UnityEditor.SceneManagement;

public static class ApplyLightingSettingsToAllScenes
{
    public struct RenderSettingsSource
    {
        public Material skybox;
        public Light sun;

        public Color subtractiveShadowColor;

        public AmbientMode ambientMode;
        public Color ambientSkyColor;
        public Color ambientEquatorColor;
        public Color ambientGroundColor;

        public DefaultReflectionMode defaultReflectionMode;
        public Texture customReflection;
        public float reflectionIntensity;
        public int reflectionBounces;

        public bool fog;

        public void Read()
        {
            skybox = RenderSettings.skybox;
            sun = RenderSettings.sun;
            subtractiveShadowColor = RenderSettings.subtractiveShadowColor;
            ambientMode = RenderSettings.ambientMode;
            ambientSkyColor = RenderSettings.ambientSkyColor;
            ambientEquatorColor = RenderSettings.ambientEquatorColor;
            ambientGroundColor = RenderSettings.ambientGroundColor;
            defaultReflectionMode = RenderSettings.defaultReflectionMode;
            customReflection = RenderSettings.customReflection;
            reflectionIntensity = RenderSettings.reflectionIntensity;
            reflectionBounces = RenderSettings.reflectionBounces;
            fog = RenderSettings.fog;
        }

        public void Write()
        {
            RenderSettings.skybox = skybox;
            RenderSettings.sun = sun;
            RenderSettings.subtractiveShadowColor = subtractiveShadowColor;
            RenderSettings.ambientMode = ambientMode;
            RenderSettings.ambientSkyColor = ambientSkyColor;
            RenderSettings.ambientEquatorColor = ambientEquatorColor;
            RenderSettings.ambientGroundColor = ambientGroundColor;
            RenderSettings.defaultReflectionMode = defaultReflectionMode;
            RenderSettings.customReflection = customReflection;
            RenderSettings.reflectionIntensity = reflectionIntensity;
            RenderSettings.reflectionBounces = reflectionBounces;
            RenderSettings.fog = fog;
        }
    }
    
    [MenuItem("Tools/Apply lighting to all scenes in BuildSettings and save all (no undo!)")]
    public static void ApplyLighting()
    {
        Debug.Log("ApplyLighting");

        //read current settings
        LightingSettings ls = null;
        try
        {
            ls = Lightmapping.lightingSettings;
        }
        catch (System.Exception) { }
        RenderSettingsSource rs = new RenderSettingsSource();
        rs.Read();
        
        //apply current settings
        int count = EditorBuildSettings.scenes.Length;
        for(int i=0; i<count; i++)
        {
            EditorSceneManager.OpenScene(EditorBuildSettings.scenes[i].path);
            Lightmapping.lightingSettings = ls;
            rs.Write();
            EditorSceneManager.MarkAllScenesDirty();
            EditorSceneManager.SaveOpenScenes();
        }
    }
}